/*
 * Decompiled with CFR 0.152.
 */
package com.simumu.entities;

import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.MathUtils;
import com.simumu.life.Brain;
import com.simumu.life.Genome;

public class Creature {
    public int gridX;
    public int gridY;
    public float energy = 100.0f;
    private Brain brain;
    public Genome genome;

    public Creature(int x, int y, Genome genome) {
        this.gridX = x;
        this.gridY = y;
        this.genome = genome;
        this.brain = new Brain(genome, 5, 2);
    }

    public void update(TiledMapTileLayer layer) {
        float[] inputs = new float[]{this.getTileValue(layer, this.gridX, this.gridY), this.getTileValue(layer, this.gridX, this.gridY + 1), this.getTileValue(layer, this.gridX, this.gridY - 1), this.getTileValue(layer, this.gridX + 1, this.gridY), this.getTileValue(layer, this.gridX - 1, this.gridY)};
        float[] outputs = this.brain.process(inputs);
        if (outputs[0] > 0.5f) {
            ++this.gridX;
        } else if (outputs[0] < -0.5f) {
            --this.gridX;
        }
        if (outputs[1] > 0.5f) {
            ++this.gridY;
        } else if (outputs[1] < -0.5f) {
            --this.gridY;
        }
        this.gridX = MathUtils.clamp(this.gridX, 0, 199);
        this.gridY = MathUtils.clamp(this.gridY, 0, 149);
        this.energy -= 1.0f;
        this.checkFeeding(layer);
    }

    private float getTileValue(TiledMapTileLayer layer, int x, int y) {
        TiledMapTileLayer.Cell cell = layer.getCell(x, y);
        if (cell == null) {
            return -1.0f;
        }
        return cell.getTile().getProperties().get("food", Float.valueOf(0.0f), Float.class).floatValue();
    }

    private void checkFeeding(TiledMapTileLayer layer) {
        TiledMapTileLayer.Cell cell = layer.getCell(this.gridX, this.gridY);
        if (cell != null) {
            String type = cell.getTile().getProperties().get("type", String.class);
            if ("water".equals(type)) {
                this.energy = 0.0f;
                return;
            }
            float food = cell.getTile().getProperties().get("food", Float.valueOf(0.0f), Float.class).floatValue();
            if (food > 0.5f) {
                this.energy += 30.0f;
            }
        }
    }
}

