/*
 * Decompiled with CFR 0.152.
 */
package com.simumu.screens;

import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.utils.Array;
import com.simumu.entities.Creature;
import com.simumu.life.Genome;
import com.simumu.world.WorldGenerator;

public class SimulationScreen
extends ScreenAdapter {
    private WorldGenerator worldGen = new WorldGenerator();
    private TiledMapTileLayer terrainLayer = (TiledMapTileLayer)this.worldGen.getMap().getLayers().get(0);
    private Array<Creature> creatures;
    private ShapeRenderer shapeRenderer = new ShapeRenderer();
    private float simulationTimer = 0.0f;

    public SimulationScreen() {
        this.creatures = new Array();
        for (int i = 0; i < 50; ++i) {
            this.spawnCreature(new Genome(10));
        }
    }

    private void spawnCreature(Genome genome) {
        this.creatures.add(new Creature(100, 75, genome));
    }

    @Override
    public void render(float delta) {
        this.simulationTimer += delta;
        if (this.simulationTimer > 0.2f) {
            this.updateLogic();
            this.simulationTimer = 0.0f;
        }
        this.worldGen.getCamera().zoom = 2.5f;
        this.worldGen.getCamera().position.set(1600.0f, 1200.0f, 0.0f);
        this.worldGen.getCamera().update();
        this.worldGen.render();
        this.shapeRenderer.setProjectionMatrix(this.worldGen.getCamera().combined);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        for (Creature c : this.creatures) {
            this.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.shapeRenderer.rect(c.gridX * 16 + 2, c.gridY * 16 + 2, 12.0f, 12.0f);
        }
        this.shapeRenderer.end();
    }

    private void updateLogic() {
        for (int i = this.creatures.size - 1; i >= 0; --i) {
            Creature c = this.creatures.get(i);
            c.update(this.terrainLayer);
            if (!(c.energy <= 0.0f)) continue;
            this.creatures.removeIndex(i);
        }
    }

    @Override
    public void dispose() {
        this.shapeRenderer.dispose();
        this.worldGen.dispose();
    }
}

