/*
 * Decompiled with CFR 0.152.
 */
package com.simumu.world;

public class PerlinNoise {
    private long seed;

    public PerlinNoise(long seed) {
        this.seed = seed;
    }

    public float getNoise(float x, float y) {
        int xInt = (int)x;
        int yInt = (int)y;
        float xFrac = x - (float)xInt;
        float yFrac = y - (float)yInt;
        float n00 = this.pseudoRandom(xInt, yInt);
        float n10 = this.pseudoRandom(xInt + 1, yInt);
        float n01 = this.pseudoRandom(xInt, yInt + 1);
        float n11 = this.pseudoRandom(xInt + 1, yInt + 1);
        float xInter1 = this.interpolate(n00, n10, xFrac);
        float xInter2 = this.interpolate(n01, n11, xFrac);
        return this.interpolate(xInter1, xInter2, yFrac);
    }

    private float interpolate(float a, float b, float t) {
        float ft = t * (float)Math.PI;
        float f = (1.0f - (float)Math.cos(ft)) * 0.5f;
        return a * (1.0f - f) + b * f;
    }

    private float pseudoRandom(int x, int y) {
        int n = x + y * 57 + (int)this.seed;
        n = n << 13 ^ n;
        return 1.0f - (float)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.0737418E9f;
    }
}

