/*
 * Decompiled with CFR 0.152.
 */
package com.simumu.world;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.simumu.world.PerlinNoise;

public class WorldGenerator {
    public static final int MAP_WIDTH = 200;
    public static final int MAP_HEIGHT = 150;
    public static final int TILE_SIZE = 16;
    private TiledMap map;
    private OrthogonalTiledMapRenderer renderer;
    private OrthographicCamera camera = new OrthographicCamera();

    public WorldGenerator() {
        this.camera.setToOrtho(false, 800.0f, 600.0f);
        this.map = this.generateMap();
        this.renderer = new OrthogonalTiledMapRenderer(this.map);
    }

    public TiledMap generateMap() {
        TiledMap map = new TiledMap();
        Texture tilesTexture = new Texture("tileset.png");
        if (tilesTexture.getWidth() < 48) {
            throw new RuntimeException("ERREUR: Le tileset.png est trop petit!");
        }
        TextureRegion[][] splitTiles = TextureRegion.split(tilesTexture, 16, 16);
        StaticTiledMapTile grassTile = new StaticTiledMapTile(splitTiles[0][0]);
        StaticTiledMapTile waterTile = new StaticTiledMapTile(splitTiles[0][1]);
        StaticTiledMapTile sandTile = new StaticTiledMapTile(splitTiles[0][2]);
        waterTile.getProperties().put("type", "water");
        waterTile.getProperties().put("food", Float.valueOf(0.0f));
        sandTile.getProperties().put("type", "sand");
        sandTile.getProperties().put("food", Float.valueOf(0.1f));
        grassTile.getProperties().put("type", "grass");
        grassTile.getProperties().put("food", Float.valueOf(1.0f));
        TiledMapTileLayer layer = new TiledMapTileLayer(200, 150, 16, 16);
        long seed = System.currentTimeMillis();
        PerlinNoise noiseGen = new PerlinNoise(seed);
        float scale = 5.0f;
        for (int x = 0; x < 200; ++x) {
            for (int y = 0; y < 150; ++y) {
                TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
                float elevation = noiseGen.getNoise((float)x / scale, (float)y / scale);
                if (elevation < -0.2f) {
                    cell.setTile(waterTile);
                } else if (elevation < 0.1f) {
                    cell.setTile(sandTile);
                } else {
                    cell.setTile(grassTile);
                }
                layer.setCell(x, y, cell);
            }
        }
        map.getLayers().add(layer);
        return map;
    }

    public void render() {
        this.camera.update();
        this.renderer.setView(this.camera);
        this.renderer.render();
    }

    public TiledMap getMap() {
        return this.map;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void dispose() {
        this.map.dispose();
        this.renderer.dispose();
    }
}

